﻿
namespace AlbumsCatalog.Web
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.ComponentModel.DataAnnotations;
    using System.Data.Objects.DataClasses;
    using System.Linq;
    using System.ServiceModel.DomainServices.Hosting;
    using System.ServiceModel.DomainServices.Server;


    // The MetadataTypeAttribute identifies AlbumMetadata as the class
    // that carries additional metadata for the Album class.
    [MetadataTypeAttribute(typeof(Album.AlbumMetadata))]
    public partial class Album
    {

        // This class allows you to attach custom attributes to properties
        // of the Album class.
        //
        // For example, the following marks the Xyz property as a
        // required property and specifies the format for valid values:
        //    [Required]
        //    [RegularExpression("[A-Z][A-Za-z0-9]*")]
        //    [StringLength(32)]
        //    public string Xyz { get; set; }
        internal sealed class AlbumMetadata
        {

            // Metadata classes are not meant to be instantiated.
            private AlbumMetadata()
            {
            }

            public int AlbumId { get; set; }

            public Artist Artist { get; set; }

            public int ArtistId { get; set; }

            public string Title { get; set; }

            public EntityCollection<Track> Tracks { get; set; }
        }
    }

    // The MetadataTypeAttribute identifies ArtistMetadata as the class
    // that carries additional metadata for the Artist class.
    [MetadataTypeAttribute(typeof(Artist.ArtistMetadata))]
    public partial class Artist
    {

        // This class allows you to attach custom attributes to properties
        // of the Artist class.
        //
        // For example, the following marks the Xyz property as a
        // required property and specifies the format for valid values:
        //    [Required]
        //    [RegularExpression("[A-Z][A-Za-z0-9]*")]
        //    [StringLength(32)]
        //    public string Xyz { get; set; }
        internal sealed class ArtistMetadata
        {

            // Metadata classes are not meant to be instantiated.
            private ArtistMetadata()
            {
            }

            public EntityCollection<Album> Albums { get; set; }

            public int ArtistId { get; set; }

            public string Name { get; set; }
        }
    }

    // The MetadataTypeAttribute identifies TrackMetadata as the class
    // that carries additional metadata for the Track class.
    [MetadataTypeAttribute(typeof(Track.TrackMetadata))]
    public partial class Track
    {

        // This class allows you to attach custom attributes to properties
        // of the Track class.
        //
        // For example, the following marks the Xyz property as a
        // required property and specifies the format for valid values:
        //    [Required]
        //    [RegularExpression("[A-Z][A-Za-z0-9]*")]
        //    [StringLength(32)]
        //    public string Xyz { get; set; }
        internal sealed class TrackMetadata
        {

            // Metadata classes are not meant to be instantiated.
            private TrackMetadata()
            {
            }

            public Album Album { get; set; }

            public Nullable<int> AlbumId { get; set; }

            public string Composer { get; set; }

            public int Milliseconds { get; set; }

            public string Name { get; set; }

            public int TrackId { get; set; }
        }
    }
}
